<?php
namespace Joomla\Component\Wmdownloads\Administrator;

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\InstallerAdapter;

defined('_JEXEC') or die;

class Script
{
    public function install($adapter)
    {
        $this->installTable();
    }

    public function update($adapter)
    {
        $this->installTable();
    }

    public function uninstall(InstallerAdapter $adapter)
    {
    }

    public function preflight($type, InstallerAdapter $adapter)
    {
    }

    public function postflight($type, InstallerAdapter $adapter)
    {
        // Protect the file storage directory
        $path = JPATH_ROOT . '/media/com_wmdownloads/files';
        if (!is_dir($path)) {
            mkdir($path, 0755, true);
        }

        // Create .htaccess to deny all access
        $htaccess = 'Order allow,deny' . PHP_EOL . 'Deny from all';
        file_put_contents($path . '/.htaccess', $htaccess);

        // Create index.html to prevent directory listing
        file_put_contents($path . '/index.html', '<html><body bgcolor="#FFFFFF"></body></html>');
    }

    private function installTable()
    {
        $db = Factory::getContainer()->get('DatabaseDriver');

        // Check if table exists
        $tables = $db->getTableList();
        $prefix = $db->getPrefix();

        if (!in_array($prefix . 'wmdownloads_items', $tables)) {
            $sql = "CREATE TABLE IF NOT EXISTS `#__wmdownloads_items` (
              `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
              `catid` int(10) NOT NULL DEFAULT 0,
              `item_mode` enum('file', 'link') NOT NULL DEFAULT 'file',
              `title` varchar(255) NOT NULL DEFAULT '',
              `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
              `description` text,
              `author` varchar(255) NOT NULL DEFAULT '',
              `type_code` varchar(50) NOT NULL DEFAULT '',
              `icon_class` varchar(50) NOT NULL DEFAULT '',
              `hits` int(10) unsigned NOT NULL DEFAULT 0,
              `file_path` varchar(255) NOT NULL DEFAULT '',
              `original_filename` varchar(255) NOT NULL DEFAULT '',
              `ext` varchar(10) NOT NULL DEFAULT '',
              `mime` varchar(100) NOT NULL DEFAULT '',
              `size_bytes` bigint(20) unsigned NOT NULL DEFAULT 0,
              `external_url` varchar(2048) NOT NULL DEFAULT '',
              `open_in_new_tab` tinyint(1) NOT NULL DEFAULT 1,
              `nofollow` tinyint(1) NOT NULL DEFAULT 1,
              `state` tinyint(3) NOT NULL DEFAULT 1,
              `access` int(10) unsigned NOT NULL DEFAULT 1,
              `language` char(7) NOT NULL DEFAULT '*',
              `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
              `created_by` int(10) unsigned NOT NULL DEFAULT 0,
              `modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
              `modified_by` int(10) unsigned NOT NULL DEFAULT 0,
              `publish_up` datetime,
              `publish_down` datetime,
              `ordering` int(11) NOT NULL DEFAULT 0,
              `checked_out` int(10) unsigned NOT NULL DEFAULT 0,
              `checked_out_time` datetime,
              PRIMARY KEY (`id`),
              KEY `idx_catid` (`catid`),
              KEY `idx_state` (`state`),
              KEY `idx_access` (`access`),
              KEY `idx_created_by` (`created_by`),
              KEY `idx_language` (`language`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";

            $db->setQuery($sql);
            try {
                $db->execute();
            } catch (\Exception $e) {
                Factory::getApplication()->enqueueMessage('Error creating table: ' . $e->getMessage(), 'error');
            }
        }
    }
}
