<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

$wa = $this->document->getWebAssetManager();
$wa->registerAndUseStyle('com_wmdownloads', 'media/com_wmdownloads/css/wmdownloads.css');
$wa->registerAndUseScript('com_wmdownloads', 'media/com_wmdownloads/js/wmdownloads.js');

// FontAwesome (assuming template has it or load it if needed, but per request "Uses Font Awesome")
// $wa->useStyle('font-awesome'); 

$user = Factory::getUser();
?>
<div class="com-wmdownloads category-list">


    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" id="wmdownloads-search" placeholder="Search downloads..." class="form-control" />
        </div>
        <div class="col-md-6">
            <div class="d-flex gap-2">
                <select id="wmdownloads-sort-field" class="form-select">
                    <option value="">Sort by...</option>
                    <option value="title">Title</option>
                    <option value="author">Author</option>
                    <option value="size">File Size</option>
                    <option value="category">Category</option>
                </select>
                <select id="wmdownloads-sort-order" class="form-select" style="max-width: 150px;">
                    <option value="asc">A-Z / Low-High</option>
                    <option value="desc">Z-A / High-Low</option>
                </select>
            </div>
        </div>
    </div>

    <?php if (!empty($this->subCategories)): ?>
        <div class="wmdownloads-subcategories mt-3">
            <select class="form-select" onchange="if (this.value) window.location.href=this.value;">
                <option value="">Select a Subcategory...</option>
                <?php foreach ($this->subCategories as $subCat): ?>
                    <?php
                    // Build link to this category
                    // We use the same view 'category' but change the ID
                    $catLink = Route::_('index.php?option=com_wmdownloads&view=category&id=' . $subCat->id);
                    ?>
                    <option value="<?php echo $catLink; ?>">
                        <?php echo $this->escape($subCat->title); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
    <?php endif; ?>

    <div id="wmdownloads-items" class="wmdownloads-items mt-3">
        <?php if (!empty($this->items)): ?>
            <?php foreach ($this->items as $item): ?>
                <?php
                $canAccess = in_array($item->access, $user->getAuthorisedViewLevels());
                if (!$canAccess)
                    continue;

                $link = Route::_('index.php?option=com_wmdownloads&task=download.download&id=' . $item->id); // Fixed task routing
                $icon = $item->icon_class ? $item->icon_class : 'fa-file';

                // Map default icons if no specific class
                if (empty($item->icon_class) && $item->type_code) {
                    switch ($item->type_code) {
                        case 'pdf':
                            $icon = 'fa-file-pdf';
                            break;
                        case 'word':
                            $icon = 'fa-file-word';
                            break;
                        case 'excel':
                            $icon = 'fa-file-excel';
                            break;
                        case 'powerpoint':
                            $icon = 'fa-file-powerpoint';
                            break;
                        case 'text':
                            $icon = 'fa-file-lines';
                            break;
                        case 'image':
                            $icon = 'fa-file-image';
                            break;
                        case 'archive':
                            $icon = 'fa-file-zipper';
                            break;
                        case 'link':
                            $icon = 'fa-link';
                            break;
                        default:
                            $icon = 'fa-file';
                    }
                }
                ?>
                <div class="wmdownloads-item card mb-2 p-3" data-title="<?php echo strtolower($this->escape($item->title)); ?>"
                    data-desc="<?php echo strtolower(strip_tags($item->description)); ?>"
                    data-author="<?php echo strtolower($this->escape($item->author)); ?>"
                    data-size="<?php echo $item->size_bytes ? $item->size_bytes : 0; ?>"
                    data-category="<?php echo strtolower($this->escape($item->category_title)); ?>">

                    <div class="d-flex align-items-center">
                        <div class="wmdownloads-icon me-3" style="font-size: 2em;">
                            <i class="fa-regular <?php echo $this->escape($icon); ?>"></i>
                        </div>
                        <div class="wmdownloads-content flex-grow-1">
                            <h4 class="mb-1">
                                <a href="<?php echo $link; ?>" <?php echo ($item->item_mode == 'link' && $item->open_in_new_tab) ? 'target="_blank"' : ''; ?>         <?php echo ($item->item_mode == 'link' && $item->nofollow) ? 'rel="nofollow"' : ''; ?>>
                                    <?php echo $this->escape($item->title); ?>
                                </a>
                            </h4>
                            <?php if ($item->description): ?>
                                <div class="description text-muted small mb-1">
                                    <?php echo \Joomla\CMS\HTML\HTMLHelper::_('string.truncate', strip_tags($item->description), 150); ?>
                                </div>
                            <?php endif; ?>

                            <div class="meta text-muted small">
                                <?php if ($this->params->get('show_author', 1) && $item->author): ?>
                                    <span class="me-3"><i class="fa fa-user"></i> <?php echo $this->escape($item->author); ?></span>
                                <?php endif; ?>

                                <?php if ($this->params->get('show_date', 1) && $item->created && $item->created != '0000-00-00 00:00:00'): ?>
                                    <span class="me-3"><i class="fa fa-calendar"></i>
                                        <?php echo HTMLHelper::_('date', $item->created, 'DATE_FORMAT_LC4'); ?></span>
                                <?php endif; ?>

                                <?php if ($this->params->get('show_size', 1) && $item->item_mode == 'file'): ?>
                                    <span class="me-3"><i class="fa fa-hdd"></i>
                                        <?php echo \Joomla\CMS\HTML\HTMLHelper::_('number.bytes', $item->size_bytes); ?></span>
                                <?php endif; ?>

                                <?php if ($this->params->get('show_hits', 1)): ?>
                                    <span class="me-3"><i class="fa fa-download"></i> <?php echo $item->hits; ?></span>
                                <?php endif; ?>

                                <?php if (!empty($item->category_title)): ?>
                                    <span class="text-primary fw-bold"><i class="fa fa-folder-open"></i>
                                        <?php echo $this->escape($item->category_title); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="wmdownloads-action ms-3">
                            <a href="<?php echo $link; ?>" class="btn btn-primary btn-sm" <?php echo ($item->item_mode == 'link' && $item->open_in_new_tab) ? 'target="_blank"' : ''; ?>>
                                <?php echo ($item->item_mode == 'link') ? 'Open <i class="fa fa-external-link"></i>' : 'Download <i class="fa fa-download"></i>'; ?>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="alert alert-info">No downloads found in this category.</div>
        <?php endif; ?>
    </div>
</div>