<?php
namespace Joomla\Component\Wmdownloads\Site\View\Category;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Factory;

defined('_JEXEC') or die;

class HtmlView extends BaseHtmlView
{
    protected $items;
    protected $params;

    public function display($tpl = null)
    {
        $this->items = $this->get('Items');
        $app = Factory::getApplication();
        $this->params = $app->getParams();

        // Get the Menu Item's Category ID (The "Root" of this section)
        $active = $app->getMenu()->getActive();
        $menuCatId = $active ? (int) $active->getParams()->get('catid') : 0;

        // Get the Current Page's Category ID
        $currentCatId = $app->getInput()->getInt('id');
        if (!$currentCatId && $menuCatId) {
            $currentCatId = $menuCatId;
        }

        $this->categoryId = $currentCatId;
        $this->subCategories = [];

        // Logic to determine the "Root" for the dropdown list
        $parentForDropdown = 0;

        if ($menuCatId) {
            // Best case: We have a menu item context
            $parentForDropdown = $menuCatId;
        } elseif ($currentCatId) {
            // Fallback: We are purely on an ID.
            // Check if this category has children.
            $model = $this->getModel();
            $children = method_exists($model, 'getSubCategories') ? $model->getSubCategories($currentCatId) : [];

            if (!empty($children)) {
                // It has children, so it is a parent. Show its children.
                $parentForDropdown = $currentCatId;
                $this->subCategories = $children; // Optimization: we already fetched them
            } else {
                // It has NO children. It is likely a subcategory itself.
                // We should show its SIBLINGS (i.e., children of its parent).
                $db = Factory::getContainer()->get('DatabaseDriver');
                $query = $db->getQuery(true)
                    ->select('parent_id')
                    ->from($db->quoteName('#__categories'))
                    ->where($db->quoteName('id') . ' = ' . (int) $currentCatId);
                $db->setQuery($query);
                $parentId = (int) $db->loadResult();

                // If parent is valid (and not 'root' usually 1), use it
                if ($parentId > 1) {
                    $parentForDropdown = $parentId;
                } else {
                    $parentForDropdown = $currentCatId;
                }
            }
        }

        // Fetch subcategories if we haven't already and have a target parent
        if ($parentForDropdown && empty($this->subCategories)) {
            $model = $this->getModel();
            if (method_exists($model, 'getSubCategories')) {
                $this->subCategories = $model->getSubCategories($parentForDropdown);
            }
        }

        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors), 500);
        }

        return parent::display($tpl);
    }
}
