<?php
namespace Joomla\Component\Wmdownloads\Site\Model;

use Joomla\CMS\Factory;
use Joomla\CMS\MVC\Model\ListModel;

defined('_JEXEC') or die;

class CategoryModel extends ListModel
{
    public function __construct($config = array())
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id',
                'a.id',
                'title',
                'a.title',
                'created',
                'a.created',
                'hits',
                'a.hits',
                'ordering',
                'a.ordering'
            );
        }

        parent::__construct($config);
    }

    protected function populateState($ordering = null, $direction = null)
    {
        // Force limit to 0 (all items) for this view
        $this->setState('list.limit', 0);

        // Optional: Call parent if we wanted normal behavior, but we want to override limit.
        // parent::populateState($ordering, $direction);

        // Set other states if needed
        $app = Factory::getApplication();
        $input = $app->getInput();
        $this->setState('list.start', $input->getInt('limitstart', 0));
    }

    protected function getListQuery()
    {
        $db = $this->getDatabase();
        $query = $db->getQuery(true);
        $user = Factory::getUser();

        $query->select(
            $this->getState(
                'list.select',
                'a.*'
            )
        );
        $query->select($db->quoteName('c.title', 'category_title'));
        $query->from($db->quoteName('#__wmdownloads_items', 'a'));
        $query->join('LEFT', $db->quoteName('#__categories', 'c') . ' ON c.id = a.catid');

        // Filter by published state
        $query->where('a.state = 1');

        // Filter by category
        // In a real scenario we'd get this from input or menu param
        $input = Factory::getApplication()->getInput();
        // Assuming routing puts id in input
        $categoryId = $input->getInt('id');

        // If no ID, get from menu parameters if possible, otherwise list all (or handle 404)
        // For now, let's assume we filter if ID exists
        if ($categoryId) {
            // Get the lft and rgt values of the current category
            $queryCat = $db->getQuery(true)
                ->select($db->quoteName(array('lft', 'rgt')))
                ->from($db->quoteName('#__categories'))
                ->where($db->quoteName('id') . ' = ' . (int) $categoryId);
            $db->setQuery($queryCat);
            $catNode = $db->loadObject();

            if ($catNode) {
                // Get all subcategory IDs (including the parent itself)
                $querySub = $db->getQuery(true)
                    ->select($db->quoteName('id'))
                    ->from($db->quoteName('#__categories'))
                    ->where($db->quoteName('lft') . ' >= ' . (int) $catNode->lft)
                    ->where($db->quoteName('rgt') . ' <= ' . (int) $catNode->rgt)
                    ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'));

                // We can use a subquery directly
                $query->where('a.catid IN (' . $querySub . ')');
            } else {
                // Category not found, fallback to exact match (which will likely return nothing)
                $query->where('a.catid = ' . (int) $categoryId);
            }
        } else {
            // Check menu params
            $activeMenu = Factory::getApplication()->getMenu()->getActive();
            if ($activeMenu) {
                $params = $activeMenu->getParams();
                $catid = $params->get('catid');
                if ($catid) {
                    // Same logic for menu param
                    $queryCat = $db->getQuery(true)
                        ->select($db->quoteName(array('lft', 'rgt')))
                        ->from($db->quoteName('#__categories'))
                        ->where($db->quoteName('id') . ' = ' . (int) $catid);
                    $db->setQuery($queryCat);
                    $catNode = $db->loadObject();

                    if ($catNode) {
                        $querySub = $db->getQuery(true)
                            ->select($db->quoteName('id'))
                            ->from($db->quoteName('#__categories'))
                            ->where($db->quoteName('lft') . ' >= ' . (int) $catNode->lft)
                            ->where($db->quoteName('rgt') . ' <= ' . (int) $catNode->rgt)
                            ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'));

                        $query->where('a.catid IN (' . $querySub . ')');
                    } else {
                        $query->where('a.catid = ' . (int) $catid);
                    }
                }
            }
        }

        // Access checks ideally here too
        // $query->where('a.access IN (' . implode(',', $user->getAuthorisedViewLevels()) . ')');

        // Add the list ordering clause.
        $query->order($db->escape('a.ordering ASC'));

        return $query;
    }
    public function getSubCategories($parentId)
    {
        $db = $this->getDatabase();
        $query = $db->getQuery(true)
            ->select($db->quoteName(array('id', 'title', 'alias')))
            ->from($db->quoteName('#__categories'))
            ->where($db->quoteName('parent_id') . ' = ' . (int) $parentId)
            ->where($db->quoteName('extension') . ' = ' . $db->quote('com_content'))
            ->where($db->quoteName('published') . ' = 1')
            ->order($db->quoteName('lft') . ' ASC');
        $db->setQuery($query);
        return $db->loadObjectList();
    }
}
