<?php
namespace Joomla\Component\Wmdownloads\Site\Controller;

use Joomla\CMS\MVC\Controller\BaseController;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

defined('_JEXEC') or die;

class DownloadController extends BaseController
{
    public function download()
    {
        $input = $this->input;
        $id = $input->getInt('id');
        $user = Factory::getUser();

        if (!$id) {
            throw new \Exception('Download ID not found', 404);
        }

        // Get item
        // Direct DB query for speed/simplicity in controller or use a model
        $db = Factory::getContainer()->get('DatabaseDriver');
        $query = $db->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__wmdownloads_items'))
            ->where($db->quoteName('id') . ' = ' . (int) $id);
        $db->setQuery($query);
        $item = $db->loadObject();

        if (!$item) {
            throw new \Exception('Item not found', 404);
        }

        // Check state
        if ($item->state != 1) {
            throw new \Exception('Item not available', 404);
        }

        // Check access
        if (!in_array($item->access, $user->getAuthorisedViewLevels())) {
            throw new \Exception('Access Denied', 403);
        }

        // Increment hits
        $query = $db->getQuery(true)
            ->update($db->quoteName('#__wmdownloads_items'))
            ->set($db->quoteName('hits') . ' = hits + 1')
            ->where($db->quoteName('id') . ' = ' . (int) $id);
        $db->setQuery($query);
        $db->execute();

        // Handle Type
        if ($item->item_mode === 'link') {
            $this->setRedirect($item->external_url);
            return true;
        } elseif ($item->item_mode === 'file') {
            $this->serveFile($item);
        }
    }

    private function serveFile($item)
    {
        $file = JPATH_ROOT . '/media/com_wmdownloads/files/' . $item->file_path;

        if (!file_exists($file)) {
            throw new \Exception('File not found on server', 404);
        }

        // Clean output buffer
        if (ob_get_contents()) {
            ob_end_clean();
        }

        // Set headers
        header('Pragma: public');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Cache-Control: private', false);
        header('Content-Type: ' . $item->mime);
        header('Content-Disposition: attachment; filename="' . $item->original_filename . '";');
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: ' . $item->size_bytes);

        // Stream file
        readfile($file);
        exit;
    }

    // Alias for 'go' task if used
    public function go()
    {
        $this->download();
    }
}
