<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;

HTMLHelper::_('behavior.core');
HTMLHelper::_('formbehavior.chosen', 'select');

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));

?>
<form action="<?php echo Route::_('index.php?option=com_wmdownloads&view=items'); ?>" method="post" name="adminForm"
    id="adminForm">
    <div id="j-sidebar-container" class="span2">
        <?php echo $this->sidebar; ?>
    </div>
    <div id="j-main-container" class="span10">

        <?php echo LayoutHelper::render('joomla.searchtools.default', array('view' => $this)); ?>

        <?php if (empty($this->items)): ?>
            <div class="alert alert-no-items">
                <?php echo "No items found"; ?>
            </div>
        <?php else: ?>
            <table class="table table-striped" id="itemList">
                <thead>
                    <tr>
                        <th width="1%" class="center">
                            <?php echo HTMLHelper::_('grid.checkall'); ?>
                        </th>
                        <th class="nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'Title', 'a.title', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'Category', 'category_title', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'Mode', 'a.item_mode', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'Type', 'a.type_code', $listDirn, $listOrder); ?>
                        </th>
                        <th class="nowrap">
                            <?php echo HTMLHelper::_('searchtools.sort', 'Hits', 'a.hits', $listDirn, $listOrder); ?>
                        </th>
                        <th width="5%" class="nowrap center">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JSTATUS', 'a.state', $listDirn, $listOrder); ?>
                        </th>
                        <th width="1%" class="nowrap center">
                            <?php echo HTMLHelper::_('searchtools.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($this->items as $i => $item):
                        $canEdit = true; // Simplified ACL
                        $link = Route::_('index.php?option=com_wmdownloads&task=item.edit&id=' . $item->id);
                        ?>
                        <tr class="row<?php echo $i % 2; ?>">
                            <td class="center">
                                <?php echo HTMLHelper::_('grid.id', $i, $item->id); ?>
                            </td>
                            <td>
                                <?php if ($canEdit): ?>
                                    <a href="<?php echo $link; ?>">
                                        <?php echo $this->escape($item->title); ?>
                                    </a>
                                <?php else: ?>
                                    <?php echo $this->escape($item->title); ?>
                                <?php endif; ?>
                                <div class="small">
                                    Alias:
                                    <?php echo $this->escape($item->alias); ?>
                                </div>
                            </td>
                            <td>
                                <?php echo $this->escape($item->category_title); ?>
                            </td>
                            <td>
                                <?php echo $this->escape($item->item_mode); ?>
                            </td>
                            <td>
                                <?php echo $this->escape($item->type_code); ?>
                            </td>
                            <td>
                                <?php echo $this->escape($item->hits); ?>
                            </td>
                            <td class="center">
                                <?php echo HTMLHelper::_('jgrid.published', $item->state, $i, 'items.', true, 'cb', $item->publish_up, $item->publish_down); ?>
                            </td>
                            <td class="center">
                                <?php echo (int) $item->id; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <?php echo $this->pagination->getListFooter(); ?>
        <?php endif; ?>

        <input type="hidden" name="task" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
</form>

<div class="card mt-4">
    <div class="card-body bg-light shadow-sm">
        <div class="row align-items-center">
            <div class="col-md-9">
                <h5 class="card-title text-primary"><i class="fas fa-info-circle"></i> WMDownloads Management</h5>
                <p class="card-text">
                    Developed by <strong>Webmaster Studios</strong>.
                    Your support helps us maintain and improve this extension.
                </p>
            </div>
            <div class="col-md-3 text-md-end">
                <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=accounts@wmstudios.com.au&currency_code=AUD&item_name=WMDownloads+Support"
                    target="_blank" class="btn btn-warning shadow-sm">
                    <i class="fab fa-paypal"></i> Support Project
                </a>
            </div>
        </div>
    </div>
</div>