<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Layout\LayoutHelper;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

?>
<form action="<?php echo Route::_('index.php?option=com_wmdownloads&layout=edit&id=' . (int) $this->item->id); ?>"
    method="post" name="adminForm" id="item-form" enctype="multipart/form-data" class="form-validate">

    <div class="main-card">
        <?php echo $this->form->renderField('title'); ?>
        <?php echo $this->form->renderField('alias'); ?>
        <?php echo $this->form->renderField('catid'); ?>
        <?php echo $this->form->renderField('item_mode'); ?>

        <div id="file-fields" style="display: <?php echo $this->item->item_mode === 'file' ? 'block' : 'none'; ?>;">
            <?php echo $this->form->renderField('file_upload'); ?>
            <?php if ($this->item->file_path): ?>
                <div class="control-group">
                    <div class="control-label"><label>Current File</label></div>
                    <div class="controls">
                        <?php echo htmlspecialchars($this->item->original_filename); ?> (
                        <?php echo $this->item->file_path; ?>)
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <div id="link-fields" style="display: <?php echo $this->item->item_mode === 'link' ? 'block' : 'none'; ?>;">
            <?php echo $this->form->renderField('external_url'); ?>
            <?php echo $this->form->renderField('open_in_new_tab'); ?>
            <?php echo $this->form->renderField('nofollow'); ?>
        </div>

        <?php echo $this->form->renderField('description'); ?>
        <?php echo $this->form->renderField('author'); ?>
        <?php echo $this->form->renderField('icon_class'); ?>
        <?php echo $this->form->renderField('state'); ?>

        <input type="hidden" name="task" value="" />
        <?php echo HTMLHelper::_('form.token'); ?>
    </div>
</form>

<div class="card mt-4">
    <div class="card-body bg-light shadow-sm">
        <div class="row align-items-center">
            <div class="col-md-9">
                <h5 class="card-title text-primary"><i class="fas fa-info-circle"></i> WMDownloads Support</h5>
                <p class="card-text">
                    Developed by <strong>Webmaster Studios</strong>.
                </p>
            </div>
            <div class="col-md-3 text-md-end">
                <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=accounts@wmstudios.com.au&currency_code=AUD&item_name=WMDownloads+Support"
                    target="_blank" class="btn btn-warning shadow-sm">
                    <i class="fab fa-paypal"></i> Support Project
                </a>
            </div>
        </div>
    </div>
</div>


<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modeSelect = document.getElementById('jform_item_mode');
        const fileFields = document.getElementById('file-fields');
        const linkFields = document.getElementById('link-fields');

        function updateFields() {
            if (modeSelect.value === 'file') {
                fileFields.style.display = 'block';
                linkFields.style.display = 'none';
            } else {
                fileFields.style.display = 'none';
                linkFields.style.display = 'block';
            }
        }

        if (modeSelect) {
            modeSelect.addEventListener('change', updateFields);
            updateFields();
        }
    });
</script>