<?php
defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

?>
<form action="<?php echo Route::_('index.php?option=com_wmdownloads'); ?>" method="post" name="adminForm" id="adminForm"
    enctype="multipart/form-data">
    <div class="main-card">
        <div class="card-body">
            <fieldset>
                <legend>CSV Import</legend>
                <div class="mb-3">
                    <label for="import_file" class="form-label">Select CSV File</label>
                    <input type="file" name="import_file" id="import_file" class="form-control" accept=".csv" required>
                    <div class="form-text">
                        Upload a CSV file with the following columns:
                        <code>filename, title, description, category_alias, author, created_date, hits</code>.<br>
                        <strong>Note:</strong> The "filename" must match a file already existing in
                        <code>/media/com_wmdownloads/files/</code>.
                    </div>
                </div>
            </fieldset>
        </div>
    </div>
    <input type="hidden" name="task" value="import.import" />
    <?php echo HTMLHelper::_('form.token'); ?>
</form>

<div class="card mt-4">
    <div class="card-body bg-light shadow-sm">
        <div class="row align-items-center">
            <div class="col-md-9">
                <h5 class="card-title text-primary"><i class="fas fa-info-circle"></i> WMDownloads Support</h5>
                <p class="card-text">
                    Developed by <strong>Webmaster Studios</strong>.
                    If you require support or custom development, please visit our website.
                </p>
            </div>
            <div class="col-md-3 text-md-end">
                <a href="https://www.paypal.com/cgi-bin/webscr?cmd=_donations&business=accounts@wmstudios.com.au&currency_code=AUD&item_name=WMDownloads+Support"
                    target="_blank" class="btn btn-warning shadow-sm">
                    <i class="fab fa-paypal"></i> Support Project
                </a>
            </div>
        </div>
    </div>
</div>