<?php
namespace Joomla\Component\Wmdownloads\Administrator\View\Items;

use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Toolbar\ToolbarHelper;

defined('_JEXEC') or die;

class HtmlView extends BaseHtmlView
{
    protected $items;
    protected $pagination;
    protected $state;
    public $filterForm;
    public $activeFilters;

    public function display($tpl = null)
    {
        $this->items = $this->get('Items');
        $this->pagination = $this->get('Pagination');
        $this->state = $this->get('State');
        $this->filterForm = $this->get('FilterForm');
        $this->activeFilters = $this->get('ActiveFilters');

        if (count($errors = $this->get('Errors'))) {
            throw new \Exception(implode("\n", $errors), 500);
        }

        $this->addToolbar();
        return parent::display($tpl);
    }

    protected function addToolbar()
    {
        ToolbarHelper::title('WMDOWNLOADS: Items');
        ToolbarHelper::addNew('item.add');
        ToolbarHelper::link('index.php?option=com_wmdownloads&view=import', 'Import CSV', 'upload');
        ToolbarHelper::editList('item.edit');
        ToolbarHelper::deleteList('JGLOBAL_CONFIRM_DELETE', 'items.delete');
    }
}
