<?php
namespace Joomla\Component\Wmdownloads\Administrator\Table;

use Joomla\CMS\Table\Table;
use Joomla\Database\DatabaseDriver;

defined('_JEXEC') or die;

class ItemTable extends Table
{
    public function __construct(DatabaseDriver $db)
    {
        parent::__construct('#__wmdownloads_items', 'id', $db);

        // Define fields that should be JSON encoded
        // $this->typeAlias = 'com_wmdownloads.item';
    }

    public function check()
    {
        // Validate category
        if (property_exists($this, 'catid') && $this->catid == 0) {
            $this->setError('Category is required');
            return false;
        }

        // Validate title
        if (trim($this->title) == '') {
            $this->setError('Title is required');
            return false;
        }

        // Generate alias if missing
        if (empty($this->alias)) {
            $this->alias = $this->title;
        }
        $this->alias = \Joomla\CMS\Application\ApplicationHelper::stringURLSafe($this->alias);
        if (trim(str_replace('-', '', $this->alias)) == '') {
            $this->alias = \Joomla\CMS\Factory::getDate()->format('Y-m-d-H-i-s');
        }

        // Validate Mode specifics
        if ($this->item_mode === 'file') {
            // File path validation handled by model usually, but table check is good too if data exists
        } elseif ($this->item_mode === 'link') {
            if (empty($this->external_url)) {
                $this->setError('External URL is required for Link mode');
                return false;
            }
        }

        return parent::check(); // TODO: Change the autogenerated stub
    }
}
