<?php
namespace Joomla\Component\Wmdownloads\Administrator\Model;

use Joomla\CMS\MVC\Model\ListModel;

defined('_JEXEC') or die;

class ItemsModel extends ListModel
{
    public function __construct($config = array())
    {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id',
                'a.id',
                'title',
                'a.title',
                'state',
                'a.state',
                'access',
                'a.access',
                'created',
                'a.created',
                'created_by',
                'a.created_by',
                'catid',
                'a.catid',
                'category_title',
                'ordering',
                'a.ordering',
                'item_mode',
                'a.item_mode',
                'hits',
                'a.hits',
                'type_code',
                'a.type_code',
                'size_bytes',
                'a.size_bytes'
            );
        }

        parent::__construct($config);
    }

    protected function getListQuery()
    {
        $db = $this->getDatabase();
        $query = $db->getQuery(true);

        $query->select(
            $this->getState(
                'list.select',
                'a.*'
            )
        );
        $query->from($db->quoteName('#__wmdownloads_items', 'a'));

        // Join over the categories.
        $query->select($db->quoteName('c.title', 'category_title'));
        $query->join('LEFT', $db->quoteName('#__categories', 'c') . ' ON c.id = a.catid');

        // Filter by published state
        $published = $this->getState('filter.state');
        if (is_numeric($published)) {
            $query->where('a.state = ' . (int) $published);
        } elseif ($published === '') {
            $query->where('(a.state IN (0, 1))');
        }

        // Filter by category.
        $categoryId = $this->getState('filter.category_id');
        if (is_numeric($categoryId)) {
            $query->where('a.catid = ' . (int) $categoryId);
        }

        // Filter by search in title
        $search = $this->getState('filter.search');
        if (!empty($search)) {
            if (stripos($search, 'id:') === 0) {
                $query->where('a.id = ' . (int) substr($search, 3));
            } else {
                $search = $db->quote('%' . str_replace(' ', '%', $db->escape(trim($search), true) . '%'));
                $query->where('(a.title LIKE ' . $search . ' OR a.alias LIKE ' . $search . ')');
            }
        }

        // Add the list ordering clause.
        $orderCol = $this->state->get('list.ordering', 'a.id');
        $orderDir = $this->state->get('list.direction', 'desc');
        $query->order($db->escape($orderCol . ' ' . $orderDir));

        return $query;
    }
}
