<?php
defined('_JEXEC') or die;

use Joomla\CMS\Dispatcher\ComponentDispatcherFactoryInterface;
use Joomla\CMS\Extension\ComponentInterface;
use Joomla\CMS\HTML\Registry;
use Joomla\CMS\MVC\Factory\MVCFactoryInterface;
use Joomla\CMS\Component\Router\RouterFactoryInterface;

use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\DI\ContainerCallback;

return new class implements ServiceProviderInterface {
    public function register(Container $container)
    {
        $container->registerServiceProvider(new \Joomla\CMS\Extension\Service\Provider\ComponentDispatcherFactory('\\Joomla\\Component\\Wmdownloads'));
        $container->registerServiceProvider(new \Joomla\CMS\Extension\Service\Provider\MVCFactory('\\Joomla\\Component\\Wmdownloads'));
        $container->registerServiceProvider(new \Joomla\CMS\Extension\Service\Provider\RouterFactory('\\Joomla\\Component\\Wmdownloads'));


        $container->set(
            ComponentInterface::class,
            function (Container $container) {
                $component = new \Joomla\CMS\Extension\Component(
                    $container->get(ComponentDispatcherFactoryInterface::class),
                    $container->get(MVCFactoryInterface::class),
                    $container->get(RouterFactoryInterface::class)
                );

                return $component;
            }
        );
    }
};
